; Routines for 64 BlazerTerm program (QuickBASIC)
; Copyright 1992 by Mark D. Rejhon
;
.8086
.MODEL MEDIUM, PASCAL, OS_DOS
.DATA
.CODE
VideoRAM        EQU     0B800h          ;Video memory segment
PUBLIC BackGround, GetBlock, PutBlock, Print64, RecordScrSize


; Declaration is:
; DECLARE SUB Background (BYVAL Attrib%)
;
; Background changes the background color of the 40 column screen
; of 64 BlazerTerm. Done by direct read/writes to page 0 of the EGA/
; VGA 40 column screen memory.
;
BackGround PROC Attrib:WORD
        pushf                       ;Save flags on stack
        push    ds                  ;Save registers
        cld                         ;Clears decimal mode flag
        mov     ax,[bp+6]           ;The color attribute
        mov     cl,4
        shl     al,cl               ;Move to the high nybble
        mov     dx,VideoRAM         ;Video memory's segment
        mov     ds,dx               ;Store in ds register
        mov     bx,ScrTop           ;Get beginning of active area
        inc     bx                  ;Increment to first color attribute
        cmp     bx,ScrBottom        ;Check if it is already end of active area
        jae     EndWri              ;Skips loop if it is
Write:  mov     cl,ds:[bx]          ;Start of loop
        and     cl,0Fh              ;Clear background nybble
        or      cl,al               ;Put in new background nybble
        mov     ds:[bx],cl          ;Store back to the screen
        add     bx,2                ;increment bx by 2
        cmp     bx,ScrBottom        ;Check if written to the end of active area
        jb      Write               ;Loop to write all color attributes
EndWri:
        pop     ds                  ;Restores registers
        popf                        ;Restores flags
        ret                         ;Return from subroutine
BackGround ENDP


; Declaration is:
; DECLARE SUB GetBlock (BYVAL BSeg%, BYVAL BOffs%, BYVAL TopRow%, BYVAL LeftCol%, BYVAL BlockHt, BYVAL BlockWid%)
;
; This subroutine reads the screen of a block of data and puts it into a
; specified fixed string.
;
GetBlock PROC GSeg:WORD, GOffs:WORD, GTopRow:WORD, GLeftCol:WORD, GBlockHt:WORD, GBlockWid:WORD
;             16         14          12            10             8              6
        pushf                           ;Save flags
        push    ds                      ;Save registers
        push    es
        push    si
        cld                             ;Clear decimal mode flag
        mov     al,[bp+12]              ;Get top row (1,1 based)
        dec     al                      ;Decrement to 0,0 based
        mov     bx,ScrWid               ;Get screen width
        mul     bx                      ;Multiply top by screen's width
        add     ax,[bp+10]              ;Add left column (1,1 based)
        dec     ax                      ;Decrement to 0,0 based
        mov     cl,1
        shl     ax,cl                   ;Multiply by two to get the address
        mov     Temp,ax                 ;Store starting address
        mov     ax,[bp+8]               ;Get block height
        or      ax,ax
        jz      EndGetBlock             ;Skips to end of routine if zero
        mov     BHeight,ax              ;Store block height
        mov     ax,[bp+6]               ;Get block width
        or      ax,ax
        jz      EndGetBlock             ;Skips to end of routine if zero
        mov     BWidth,ax               ;Store block width
        mov     SaveWidth,ax            ;Save a copy of the block width
        mov     ax,[bp+16]              ;Get fixed string's data segment
        mov     es,ax                   ;Put in es register
        mov     si,[bp+14]              ;Get fixed string's offset
        mov     ax,VideoRAM             ;EGA/VGA video memory segment
        mov     ds,ax                   ;Put in ds register
        mov     bx,Temp                 ;Get screen offset location
StartGet:
        cmp     bx,ScrSize              ;Is it off the screen yet?
        jae     EndGetBlock             ;Skip the below loop if it is.
        mov     ax,ds:[bx]              ;Get character and attribute off screen
        mov     es:[si],ax              ;Put char and attr into fixed string
        add     bx,2                    ;Increment screen char cell location
        add     si,2                    ;Increment string offset
        dec     BWidth                  ;Decrement block width
        jne     StartGet                ;Keep getting characters if not zero
        mov     ax,SaveWidth
        mov     BWidth,ax               ;Restore block width
        mov     cx,ScrWid               ;Get screen's width
        add     Temp,cx
        add     Temp,cx                 ;Increment to next screen row
        mov     bx,Temp                 ;Put into bx register
        dec     BHeight                 ;Decrement block height
        jne     StartGet                ;Keep getting characters if not equal
EndGetBlock:
        pop     si
        pop     es
        pop     ds                      ;Restore registers
        popf                            ;Restore flags
        ret
GetBlock ENDP


; Declaration is:
; DECLARE SUB PutBlock (BYVAL BSeg%, BYVAL BOffs%, BYVAL TopRow%, BYVAL LeftCol%, BYVAL BlockHt, BYVAL BlockWid%)
;
; This subroutine reads the specified fixed string and puts the data onto
; the screen.
;
PutBlock PROC GSeg:WORD, GOffs:WORD, GTopRow:WORD, GLeftCol:WORD, GBlockHt:WORD, GBlockWid:WORD
        pushf                           ;Save flags
        push    ds                      ;Save registers
        push    es
        push    si
        cld                             ;Clear decimal mode flag
        mov     al,[bp+12]              ;Get top row (1,1 based)
        dec     al                      ;Decrement to 0,0 based
        mov     bx,ScrWid               ;Get screen width
        mul     bx                      ;Multiply top by screen's width
        add     ax,[bp+10]              ;Add left column (1,1 based)
        dec     ax                      ;Decrement to 0,0 based
        mov     cl,1
        shl     ax,cl                   ;Multiply by two to get the address
        mov     Temp,ax                 ;Store starting address
        mov     ax,[bp+8]               ;Get block height
        or      ax,ax
        jz      EndPutBlock             ;Skips to end of routine if zero
        mov     BHeight,ax              ;Store block height
        mov     ax,[bp+6]               ;Get block widht
        or      ax,ax
        jz      EndPutBlock             ;Skips to end of routine if zero
        mov     BWidth,ax               ;Store block width
        mov     SaveWidth,ax            ;Save a copy of the block width
        mov     ax,[bp+16]              ;Get fixed string's data segment
        mov     es,ax                   ;Put in es register
        mov     si,[bp+14]              ;Get fixed string's offset
        mov     ax,VideoRAM             ;EGA/VGA video memory segment
        mov     ds,ax                   ;Put in ds register
        mov     bx,Temp                 ;Get screen offset location
StartPut:
        cmp bx,ScrSize                  ;Is it off the screen yet?
        jae     EndPutBlock             ;Skip the below loop if it is.
        mov     ax,es:[si]              ;Get char and attr from fixed string
        mov     ds:[bx],ax              ;Put character and attribute on screen
        add     bx,2                    ;Increment screen char cell location
        add     si,2                    ;Increment string offset
        dec     BWidth                  ;Decrement block width
        jne     StartPut                ;Keep getting characters if not zero
        mov     ax,SaveWidth
        mov     BWidth,ax               ;Restore block width
        mov     cx,ScrWid               ;Get screen's width
        add     Temp,cx
        add     Temp,cx                 ;Increment to next screen row
        mov     bx,Temp                 ;Put into bx register
        dec     BHeight                 ;Decrement block height
        jne     StartPut                ;Keep getting characters if not equal
EndPutBlock:
        pop     si
        pop     es
        pop     ds                      ;Restore registers
        popf                            ;Restore flags
        ret
PutBlock ENDP


; Declaration is:
; DECLARE SUB Print64 (BYVAL PRow%, BYVAL PCol%, Str64 AS STRING)
;
; Respective offsets of the parameters on the stack are: 10,8 and 6.
; This subroutine is a high speed, direct-screen-writing print subroutine
; of IBM ASCII strings in C64-POKE-style codes on the screen.
;
; Upon Entry: ds holds the string's segment for fourth parameter.
;
Print64 PROC PRow:WORD, PCol:WORD, StrOffs:WORD
        pushf                   ;Saves flags
        push    ds              ;Saves registers
        push    es
        push    di
        push    si
        push    bp
        cld                     ;Clears decimal mode flag
        mov     ax,[bp+10]      ;Row (1,1 based)
        dec     ax              ;Decrement by 1 for 0,0 based coordinates
        mov     cx,ScrWid       ;Get Screen's width
        mul     cl
        add     ax,[bp+8]       ;Column (1,1 based)
        dec     ax              ;Decrement by 1 for 0,0 based cordinates
        mov     cl,1
        shl     ax,cl           ;Multiply by 2
        mov     Temp,ax         ;The screen memory location in dx
        mov     si,[bp+6]       ;Get string descriptor's offset
        mov     ax,[si]         ;Get string's length
        or      ax,ax
        jz      StopWriting     ;Jumps to end of subroutine if empty string
        mov     StrLeng,ax      ;Store string's length
        mov     ax,[si+2]       ;Get actual string's offset
        mov     si,ax           ;si holds the offset of the string.
        mov     ax,VideoRAM     ;EGA/VGA video memory segment
        mov     es,ax           ;into ES segment register
        mov     bx,OFFSET XLatIBM_to_CBM        ;Get translate table's offset
        push    ds              ;ds already holds string's segment
        pop     ax              ;transferred to ax
        mov     String64,ax     ;Store string's segment into String64
        push    cs              ;cs holds the translate's table's segment.
        pop     ax              ;transferred to ax
        mov     XLatSeg,ax      ;Store translate table's segment into XLatSeg
        mov     bp,Temp         ;Get screen location to write first letter on
        xor     ax,ax           ;Clear ax to keep ah free
KeepWriting:
        cmp     bp, ScrSize     ;Is the pointer out of the screen's range?
        jae     StopWriting     ;Stops writing screen if it is.
        mov     al,ds:[si]      ;Fetch IBM ASCII character from string
        cmp     al,ForeCode     ;Check if it is a foreground color change code
        jne     CheckNext       ;Skips color change if it isn't.
        inc     si              ;Increments string pointer
        dec     StrLeng         ;Decrement string length
        jz      StopWriting     ;Exits loop if end of string
        mov     al,ds:[si]      ;Fetch IBM ASCII character from string
        and     al,0Fh          ;Isolate color byte
        and     Color,0F0h      ;Clear old color out of attribute byte
        or      Color,ax        ;Put new color into attribute byte
        jmp     NextChar        ;Go onto reading the next character
CheckNext:
        cmp     al,BackCode     ;Check if it is a foreground color change code
        jne     WriteChar       ;Skips background change if it isn't.
        inc     si              ;Increments string pointer
        dec     StrLeng         ;Decrement string length
        jz      StopWriting     ;Exits loop if end of string
        mov     al,ds:[si]      ;Fetch IBM ASCII character from string
        and     al,0Fh          ;Isolate color byte
        mov     cl,4            ;For next instruction
        shl     al,cl           ;Multiply by 16 by shifting bits 4 times
        and     Color,0Fh       ;Clear old color out of attribute byte
        or      Color,ax        ;Put new color into attribute byte
        jmp     NextChar        ;Go onto reading the next character
WriteChar:
        mov     ds,XLatSeg      ;Get translation table segment
        xlat                    ;Lookup the CBM ASCII code
        mov     ds,String64     ;Restore string's segment
        mov     es:[bp],al      ;Store new ASCII code on the screen
        inc     bp              ;Increment to the attribute byte
        mov     cx,Color        ;Fetch attribute for CBM colors
        mov     es:[bp],cl      ;Store color on new ASCII code on the screen
        inc     bp              ;Increment to the next screen byte
NextChar:
        inc     si              ;Increment string pointer
        dec     StrLeng         ;Decrement string length
        jnz     KeepWriting     ;Stops loop when the full string is printed
StopWriting:
        pop     bp
        pop     si
        pop     di
        pop     es
        pop     ds              ;restore registers
        popf                    ;restores flags
        ret                     ;Return from subroutine
Print64 ENDP

; Declaration is:
; DECLARE SUB RecordScrSize (BYVAL SWidth%, BYVAL SHeight%, BYVAL TopRow%, BYVAL BotRow%)
;
; This subroutine calculates the screen's size, beginning screen address and
; ending screen address, and records the data in the work area below, for
; the 'Background' and 'Print64' routines to use.
;
RecordScrSize PROC SWidth:WORD, SHeight:WORD, TopRow:WORD, BotRow:WORD
        pushf                           ;Save flags
        push    ds                      ;Save register
        cld                             ;clear decimal mode
        xor     ax,ax                   ;clear ax
        xor     bx,bx                   ;clear bx
        mov     bl,[bp+12]              ;get screen width
        mov     ScrWid,bx               ;store screen width
        mov     al,[bp+10]              ;get screen height
        mov     ScrHt,ax                ;store screen height
        mul     bl                      ;multiply to get screen's size in chars
        mov     cl,1
        shl     ax,cl                   ;multiply by 2 to get total screen size
        mov     ScrSize,ax              ;store screen's size
        mov     ax,[bp+8]               ;get top row of active screen area, 1 based
        jz      SkipDec                 ;Skips decrementing if already 0
        dec     ax                      ;decrement to get 0 based
SkipDec:
        mul     bx                      ;multiply by screen width
        shl     ax,cl                   ;multiply by 2 to get address
        cmp     ax,ScrSize              ;Checks if it is beyond screen's size
        jbe     SkipBegReset            ;Skips if it isn't
        mov     ax,ScrSize
SkipBegReset:
        mov     ScrTop,ax               ;Store address
        mov     ax,[bp+6]               ;get bottom row of active area, 1 based
        mul     bx                      ;multiply by screen width
        shl     ax,cl                   ;multiply by 2 to get address
        cmp     ax,ScrSize              ;Checks if it is beyond screen's size
        jbe     SkipEndReset            ;Skips if it isn't
        mov     ax,ScrSize
SkipEndReset:
        mov     ScrBottom,ax            ;Store address (which is +1 above end)
        pop     ds
        popf
        ret
RecordScrSize ENDP

ScrWid      WORD 40         ;Screen's width
ScrHt       WORD 25         ;Screen's height
ScrSize     WORD 2000       ;Screen's size in bytes
ScrTop      WORD 0          ;Store address of start of active screen area
ScrBottom   WORD 2000       ;Store address of end of active screen area
Color       WORD 1          ;Storage for attribute
ForeCode    BYTE "{"        ;Foreground color initiation (escape) code
BackCode    BYTE "}"        ;Background color initiation (escape) code
Temp        WORD ?          ;Temporary storage for screen location
StrLeng     WORD ?          ;Temp storage for string's length
String64    WORD ?          ;Temp storage for string's data segment
XLatSeg     WORD ?          ;Temp storage for translation table's data segment
BHeight     WORD ?          ;Temp storage for Get/Put Block height
BWidth      WORD ?          ;Temp storage for Get/Put Block width
SaveWidth   WORD ?          ;Temp storage for copy of Get/Put Block width
XLatIBM_to_CBM:             ;IBMASCII to CBMASCII rough translation table
        BYTE   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
        BYTE  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31
        BYTE  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47
        BYTE  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63
        BYTE   0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79
        BYTE  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 27, 47, 29, 30,100
        BYTE  64,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15
        BYTE  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 93, 29, 94, 31
        BYTE 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143
        BYTE 144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159
        BYTE 160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175
        BYTE 176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191
        BYTE 192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207
        BYTE 208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223
        BYTE 224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
        BYTE 240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255

END

